
#ifndef __AP2GUI_H
#define __AP2GUI_H

#include <coecntrl.h>
#include <coeccntx.h>

#include <eikappui.h>
#include <eikapp.h>
#include <eikdoc.h>

#include "ap2view.h"
#include "EmuApple.h"
#include "AppleDiskII.h"
#include "gcr.h"
#include "fragplay.h"

// UID of app

const TUid KUidAppleIIApp= { 0x1000118d } ;

//
// thread handler (to run CPU engine)
//

class CAppleIICPURunner : public CBase, TAppleIISoundListener
	{
public:
	CAppleIICPURunner(TAppleII* aModel);
	CAppleIICPURunner::~CAppleIICPURunner();
	void Start(TInt aClockSpeed);
	void Stop();
	void SetSound(TSoundVolume aVolume);
	static TInt Tick(TAny* aObject); // directly called
	void DoTick();
	void soundChanged(int clock, int newstate);
private:
	TInt iClockSpeed, iTicksPerSec, iCyclesPerTick, iPeriod;
	// the periodic timer
	CPeriodic* iCPUTimer;
	// the CPU model
	TAppleII* iModel;
	// the sound device
	TFragmentPlayer iSpeaker;
	// the current volume setting
	TSoundVolume iVolume;
	// should we worry about sound?
	TInt iSoundAlert;
    };


//
// class CAppleIIAppView
//

class CAppleIIAppView : public CCoeControl, public MCoeControlBrushContext
    {
public:
    void ConstructL(const TRect& aRect, TAppleII* aModel);
    ~CAppleIIAppView();
	// changing view
	void ConstructViewL();
	// functions for TCallBack protocol
	void StartUpdate(TInt aInterval);
	void StopUpdate();
	static TInt Tick(TAny* aObject); // directly called
	void DoTick();
private: // from CCoeControl
	void Draw(const TRect& /*aRect*/) const;
	TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
    TInt CountComponentControls() const;
    CCoeControl* ComponentControl(TInt aIndex) const;
public: // also from MGraphicsExampleObserver
	void NotifyStatus(const TDesC& aMessage);
private: // new function
	void CreateLabelL();
private: // data
	// model stuff
	TAppleII* iModel; // model we're working with
	// view
	CAppleIIView* iView; // view of apple display
	// label stuff
	CEikLabel* iLabel; // label for status messages
	CFont* iLabelFont;
	// background
	CFbsBitmap* iBackgroundBitmap;
	// timer stuff
	CPeriodic* iRefreshTimer; // timer for update
	TInt iRefreshInterval; // update interval
	TTime iLastMarkTime; // used to compute avg CPU speed
	TInt iLastMarkClock;
    };

//
// CAppleIIAppUi
//

class CAppleIIAppUi : public CEikAppUi
    {
public:
    void ConstructL();
	~CAppleIIAppUi();
private: // from CEikAppUi
	void HandleCommandL(TInt aCommand);
	void RunBenchmark();
	void OpenDiskImageL(int drivenum);
	void SetPauseL(TInt aPauseState);
	void DoPauseStateChangeL();
	virtual void HandleForegroundEventL(TBool aForeground);
private:
    CAppleIIAppView* iAppView;
	TAppleII* iModel;
	CAppleIICPURunner* iCPUHandler;
	TFileName iImagesDir;
	TBool iPowerOn;
	TInt iPauseState;
};

//
// CAppleIIDocument
//

class TEikonDiskProvider : public TAppleDiskProvider
{
private:
	RFs fsSession;
	RFile fDiskImage;
	TBool isOpened, isWriteProtected;
	TAppleGCRCodec iGCR;
	TAppleCookedTrack iTrack;
public:
	TEikonDiskProvider();
	virtual ~TEikonDiskProvider();
	void OpenFileL(const TFileName& aFileName);
	virtual void getTrackData(int track, byte* data);
	virtual void setTrackData(int track, byte* data);
	virtual int getIsWriteProtected();
};

class CAppleIIDocument : public CEikDocument
	{
public:
	CAppleIIDocument(CEikApplication& aApp);
	~CAppleIIDocument();
	void SetupDocumentL();
	TAppleII* Model() { return(&iModel); }
	void DoOpenDiskImageL(const TFileName& aFileName, int aDriveNum);
private: // from CEikDocument
	CEikAppUi* CreateAppUiL();
private:
	TAppleII iModel;
	TEikonDiskProvider dp[2];
	};

//
// CAppleIIApplication
//

class CAppleIIApplication : public CEikApplication
	{
private: // from CApaApplication
	CApaDocument* CreateDocumentL();
	TUid AppDllUid() const;
	};

#endif
